#!/bin/sh
WAS_HOME="$(was.install.root)"
JAVA_HOME="$(java.install.root)"
WAS_CELL=$(cell.name)
WAS_NODE=$(node.name)

#ulimit -n 10000

ITP_LOC="$WAS_HOME"/deploytool/itp
CONFIG_ROOT="$WAS_HOME"/config

CLIENTSAS=-Dcom.ibm.CORBA.ConfigURL=file:"$WAS_HOME"/properties/sas.client.props
STDINCLIENTSAS=-Dcom.ibm.CORBA.ConfigURL=file:"$WAS_HOME"/properties/sas.stdinclient.props
SERVERSAS=-Dcom.ibm.CORBA.ConfigURL=file:"$WAS_HOME"/properties/sas.server.props
CLIENTSOAP=-Dcom.ibm.SOAP.ConfigURL=file:"$WAS_HOME"/properties/soap.client.props

QUALIFYNAMES=-qualifyHomeName
PATH="$JAVA_HOME"/ibm_bin:"$JAVA_HOME"/bin/:"$JAVA_HOME"/jre/bin:$PATH
WAS_EXT_DIRS="$JAVA_HOME"/lib:"$WAS_HOME"/classes:"$WAS_HOME"/lib:"$WAS_HOME"/lib/ext:"$WAS_HOME"/web/help:"$ITP_LOC"/plugins/com.ibm.etools.ejbdeploy/runtime
WAS_CLASSPATH="$WAS_HOME"/properties:"$WAS_HOME"/lib/bootstrap.jar:"$WAS_HOME"/lib/j2ee.jar:"$WAS_HOME"/lib/lmproxy.jar:"$WAS_HOME"/lib/urlprotocols.jar

CLOUDSCAPE_HOME="$WAS_HOME"/cloudscape

PLATFORM=`/bin/uname`
case $PLATFORM in

  AIX)

    WAS_LIBPATH="$WAS_HOME"/bin:/usr/mqm/java/lib:/usr/opt/wemps/lib
    WAS_EXT_DIRS="$WAS_EXT_DIRS":/usr/mqm/java/lib:/usr/opt/wemps/lib
    PATH=/usr/opt/wemps/bin:$PATH
    NLSPATH=/usr/lib/nls/msg/%L/%N:/usr/lib/nls/msg/en_US/%N:${NLSPATH:=}
    WEMPS_REGISTRY=/var/wemps/registry
    WAS_BOOTCLASSPATH="$JAVA_HOME"/jre/lib/ext/ibmorb.jar;;

  Linux)

    WAS_LIBPATH="$WAS_HOME"/bin:/opt/mqm/java/lib:/opt/wemps/lib
    WAS_EXT_DIRS="$WAS_EXT_DIRS":/opt/mqm/java/lib:/opt/wemps/lib
    PATH=/opt/wemps/bin:$PATH
    NLSPATH=/usr/lib/locale/%L/LC_MESSAGES/%N:${NLSPATH:=}
    WEMPS_REGISTRY=/var/wemps/registry
    JAVA_HIGH_ZIPFDS=200
    WAS_BOOTCLASSPATH="$JAVA_HOME"/jre/lib/ext/ibmorb.jar

    # If it appears that the NPTL threading library is present, set
    # the loader variable to switch it back to LinuxThreads.
    # 0 == NPTL, 1 == LinuxThreads.
    getconf GNU_LIBPTHREAD_VERSION 2>&1 | grep NPTL > /dev/null 2>&1
    if [ $? -eq 0 ] ; then
      LD_ASSUME_KERNEL=2.4.19
      export LD_ASSUME_KERNEL
    fi
    ;;

  SunOS)

    if [ "$LANG" = "" ]
    then
       LANG=C
       export LANG
    fi
    WAS_LIBPATH="$WAS_HOME"/bin:/opt/mqm/java/lib:/opt/wemps/lib
    WAS_EXT_DIRS="$WAS_EXT_DIRS":/opt/mqm/java/lib:/opt/wemps/lib
    PATH=/opt/wemps/bin:$PATH
    NLSPATH=/usr/lib/locale/%L/LC_MESSAGES/%N:${NLSPATH:=}
    WEMPS_REGISTRY=/var/wemps/registry
    WAS_BOOTCLASSPATH="$JAVA_HOME"/jre/lib/ext/ibmorb.jar:"$JAVA_HOME"/jre/lib/ext/ibmDeflatorOutputStream.jar:"$JAVA_HOME"/jre/lib/ext/ibmext.jar;;

  HP-UX)

    WAS_LIBPATH="$WAS_HOME"/bin:/opt/mqm/java/lib:/opt/wemps/lib
    WAS_EXT_DIRS="$WAS_EXT_DIRS":/opt/mqm/java/lib:/opt/wemps/lib
    PATH=/opt/wemps/bin:$PATH
    NLSPATH=/usr/lib/nls/msg/%L/%N:${NLSPATH:=}
    WEMPS_REGISTRY=/var/wemps/registry
    WAS_BOOTCLASSPATH="$JAVA_HOME"/jre/lib/ext/ibmorb.jar:"$JAVA_HOME"/jre/lib/ext/ibmDeflatorOutputStream.jar:"$JAVA_HOME"/jre/lib/ext/ibmext.jar;;

  *)

    WAS_LIBPATH="$WAS_HOME"/bin:/opt/mqm/java/lib:/opt/wemps/lib
    WAS_EXT_DIRS="$WAS_EXT_DIRS":/opt/mqm/java/lib:/opt/wemps/lib
    PATH=/opt/wemps/bin:$PATH
    NLSPATH=/usr/lib/locale/%L/LC_MESSAGES/%N:${NLSPATH:=}
    WEMPS_REGISTRY=/var/wemps/registry
    WAS_BOOTCLASSPATH="$JAVA_HOME"/jre/lib/ext/ibmorb.jar;;

esac

export PATH WAS_HOME WAS_CELL WAS_NODE JAVA_HOME ITP_LOC CLIENTSAS STDINCLIENTSAS SERVERSAS QUALIFYNAMES WAS_EXT_DIRS WAS_CLASSPATH CONFIG_ROOT WAS_BOOTCLASSPATH NLSPATH WEMPS_REGISTRY JAVA_HIGH_ZIPFDS WAS_LIBPATH

if [ "${WAS_USER_SCRIPT:=}" != "" ] ; then
   . $WAS_USER_SCRIPT
fi
if [ "${USER_INSTALL_ROOT:=}" != "" ] ; then
   USER_INSTALL_PROP="-Duser.install.root=$USER_INSTALL_ROOT"
   export USER_INSTALL_PROP
fi
